import itertools
import os
import sys
import optparse
import xml.etree.ElementTree as ET

#we need to import some python modules from the sumo/tools directory
import time

if 'SUMO_HOME' in os.environ:
    sys.path.append(os.path.join(os.environ['SUMO_HOME'], 'tools'))
else:
    sys.exit("Please declare the environment variable SUMO HOME")

from sumolib import *
import traci

def get_options():
    opt_parser= optparse.OptionParser()
    opt_parser.add_option("--nogui",action="store_true",default=False,help="run the commandline version of sumo")
    options, args= opt_parser.parse_args()
    return options

#contains the TraCi loop
def run(stopList,l, eID):
    print("HELLO")
    print("the assigned stop ids=", stopList)
    print("The whole stop ids are=", l)
    print("Lane IDS=", eID)


    step=0
    flag = 0


    while traci.simulation.getMinExpectedNumber() > 0:
        traci.simulationStep()
        step+=1
        busIDs = traci.vehicle.getIDList()
        for i in range(len(busIDs)):
            print("The bus id is:",i)
            for index, num_lists in enumerate(stopList):
                if int(i) == index:
                    print("equal indexes")
                    if len(stopList[index]) == 1:
                        print("till here okay")
                        # get the index of this stop and then get the edge of this stop to put it in the insert stop
                        indx = l.index(stopList[index][0])
                        edge = eID.__getitem__(indx)
                        print("the edge is",type(edge))
                        #traci.vehicle.insertStop(str(i), stopList[index][0], edgeID=str(edge), duration=10)
                        traci.vehicle.setBusStop(str(i), stopList[index][0], duration=1)
                        traci.vehicle.setBusStop(str(i), 'busStop_E15_0_1', duration=1)
                        print("I am here with these stops", stopList[index])
                    # else:
                    #     for j in stopList[index]:
                    #         #traci.vehicle.setBusStop(str(i), stopList, duration=2.0)

        # for i in range(len(busIDs)):
        #     if step%10==0:
        #         break
        #     for index, num_lists in enumerate(stopList):
        #         if int(i)==index:
        #             print("equal indexes")
        #             if len(stopList[index])==1:
        #                 print("till here okay")
        #                 traci.vehicle.insertStop(str(i),stopList[index][0])
        #                 traci.vehicle.setBusStop(str(i),'busStop_E6_0_1', duration=1)
        #                 traci.vehicle.setBusStop(str(i),'busStop_E11_0_3', duration=0.5)
        #                 print("I am here with these stops", stopList[index])
        #             else:
        #                 for j in stopList[index]:
        #                     traci.vehicle.setBusStop(str(i), stopList, duration=2.0)
        #     stopsofbus = traci.vehicle.getStops(str(i))
        #     print("Bus ",i," have these stops:", stopsofbus)





        #stopping condition

        verifyS = 0
        verifyB = 0
        if step > 100:
            for stop in stopIds:
                waitingPassList = traci.simulation.getBusStopWaitingIDList(
                    stop)  # retreives the ids of the passengers waiting at stop
                if len(waitingPassList) == 0:
                    verifyS += 1
            for bus in busIDs:
                persons = traci.vehicle.getPersonIDList(bus)
                if (len(persons)) == 0:
                    verifyB += 1
            if verifyS == len(stopIds) and verifyB == len(busIDs):
                print("This simulation took", step, "steps ")
                traci.close()
                sys.stdout.flush()

    traci.close()
    sys.stdout.flush()


#The main to run the program
if __name__ == "__main__":
    options= get_options()
    #check binary
    if options.nogui:
        sumoBinary= checkBinary('sumo')
    else:
        sumoBinary= checkBinary('sumo-gui')

    #traci starts sumo as a subporcess and then this script connects and runs
    traci.start([sumoBinary,"-c","Sumo_SA_Conf.sumocfg","--vehroute-output","vehroute.xml","--tripinfo-output","tripinfo.xml"])

    #read the adds file to get the stop IDS
    tripinfo = ET.parse('Adds.xml')
    root = tripinfo.getroot()
    stopIds = []
    edgeID=[]
    for child in root:
        stopIds.append(child.get("id"))
        #read the edgesd ID and give it to the function becauseit has the same order as stopID
        edgeID.append(child.get("lane"))
    l = list(stopIds)
    eID= list(edgeID)

    # read the vehicles IDs xml  file
    veh = ET.parse('route.rou.xml')
    root = veh.getroot()
    busIds = []
    for child in root:
        if child.tag == "vehicle" and child.get("type") == "Bus":
            busIds.append(child.get("id"))
    print("the bus ids are:", busIds)

    comb = []
    for k in range(len(l)):
        comb += itertools.combinations(l, k + 1)

    # creating 3 combination=nb of buses for stopping pattern
    comb_list1 = [list(t) for t in comb]
    comb_list2 = [list(t) for t in comb]
    comb_list3 = [list(t) for t in comb]


    count = 0
    for s in comb_list1:
        stoplist=[]
        stoplist.append(s)
        #if len(s) == 1:
        print("Stop for bus 1",s)
            # traci.vehicle.setBusStop("0", str(s[0]), 2.0,flags=0)
        for h in comb_list2:
            print("Stop for bus 2",h)
            stoplist.append(h)
            # give the h for the second bus
            for g in comb_list3:
                stoplist.append(g)
                print("Stop for bus 3",g)
                run(stoplist, l, eID)
                stoplist.remove(g)
                count += 1
                print("count",count)
            stoplist.remove(h)
        stoplist.remove(s)
